/* 
 *  UserExecutor.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient;

import com.avaya.ccs.javafxrefclient.request.ACWRequest;
import com.avaya.ccs.javafxrefclient.request.GetAgentSignatureRequest;
import com.avaya.ccs.javafxrefclient.request.GetSkillsetsRequest;
import com.avaya.ccs.javafxrefclient.request.GetUserDataRequest;
import com.avaya.ccs.javafxrefclient.request.LoginRequest;
import com.avaya.ccs.javafxrefclient.request.LogoutRequest;
import com.avaya.ccs.javafxrefclient.request.NotReadyRequest;
import com.avaya.ccs.javafxrefclient.request.OriginateEmailRequest;
import com.avaya.ccs.javafxrefclient.request.ReadyRequest;
import com.avaya.ccs.javafxrefclient.request.SetAgentSignatureRequest;
import com.avaya.ccs.api.NotificationEventI;
import com.avaya.ccs.api.UserI;
import com.avaya.ccs.api.UserListenerI;
import com.avaya.ccs.api.enums.ContactType;

import javafx.concurrent.Task;

public class UserExecutor extends Executor implements UserListenerI {

    private static final Logger LOG = Logger.getLogger(UserExecutor.class);
    private final JavaFXRefClient gui;

    public UserExecutor(JavaFXRefClient gui) {
        this.gui = gui;
    }

    public void logout(String userID) {
        String methodName = "logout() ";
        LOG.debug(methodName + "+ UserID:" + userID);
        executeOutgoingRequest(new LogoutRequest(userID));
        LOG.trace(methodName + "-");
    }

    public void login(String userID, String password, String zone) {
        String methodName = "login() ";

        LOG.debug(methodName + "+ UserID:" + userID + " PasswordLength:" + password.length() + " Zone:"
                + ((zone == null) ? "NULL" : zone));
        executeOutgoingRequest(new LoginRequest(userID, password, zone));
        LOG.trace(methodName + "-");
    }

    public void ready(String userID) {
        String methodName = "ready() ";
        LOG.debug(methodName + "+ UserID:" + userID);
        executeOutgoingRequest(new ReadyRequest(userID));
        LOG.trace(methodName + "-");
    }

    public void notReady(String userID, String reason) {
        String methodName = "notReady() ";
        LOG.debug(methodName + "+ UserID:" + userID + "Reason:" + reason);
        executeOutgoingRequest(new NotReadyRequest(userID, reason));
        LOG.trace(methodName + "-");
    }

    public void ACW(String userID, String reason) {
        String methodName = "ACW() ";
        LOG.debug(methodName + "+ UserID:" + userID + "Reason:" + reason);
        executeOutgoingRequest(new ACWRequest(userID, reason));
        LOG.trace(methodName + "-");
    }

    public void getUserData() {
        String methodName = "getUserData() ";
        LOG.debug(methodName + "+");
        executeOutgoingRequest(new GetUserDataRequest(gui.getUserGUI(), gui.getSupervisorGUI()));
        LOG.trace(methodName + "-");
    }
    
    public void setAgentSignature(String userId, String htmlSignature) {
    	 String methodName = "setAgentSignature() ";
         LOG.debug(methodName + "+");
         executeOutgoingRequest(new SetAgentSignatureRequest(userId, htmlSignature));
         LOG.trace(methodName + "-");
		
	}
    
    public void getAgentSignature(String userId) {
   	 String methodName = "getAgentSignature() ";
        LOG.debug(methodName + "+");
        executeOutgoingRequest(new GetAgentSignatureRequest(userId));
        LOG.trace(methodName + "-");
		
	}
  
    
    public void originateEmail(String userId) {
     	 String methodName = "originateEmail() ";
          LOG.debug(methodName + "+");
          executeOutgoingRequest(new OriginateEmailRequest(userId));
          LOG.trace(methodName + "-");		
  	}

    @Override
    public void onUserEvent(NotificationEventI<UserI> user) {
        String methodName = "onUserEvent() ";
        LOG.info(methodName + user.getNotificationType() + " UserI-ID:" + user.getNotificationObject().getId());
        Task<UserData> t = new UserEventTask(user, gui.getUserGUI(), gui.getSupervisorGUI());
        executeIncomingEvent(t);
    }
    
  
}
